#include "StdAfx.h"
#include "ConfigSPCCustomDll.h"
#include "DllCustomDll.h"
////////////////////////////////////////////////////////////////////////////////////
CConfigSPCCustomDll::CConfigSPCCustomDll(CDllManager* iDllManager):CConfigSPC(iDllManager)
{
	
}
////////////////////////////////////////////////////////////////////////////////////
CConfigSPCCustomDll::~CConfigSPCCustomDll(void)
{
	if (mDllManager->SaveOnExit())
		Save();
	// The parent Save() function is automaticaly called
}
////////////////////////////////////////////////////////////////////////////////////
Bool CConfigSPCCustomDll::Load()
{
	// save params of this custom class
	SetParamN(LoadIntInSection(kParamNKey, kParamNDefault));
	// call the parent function
	return CConfigSPC::Load();
}
////////////////////////////////////////////////////////////////////////////////////
Bool CConfigSPCCustomDll::Save()
{
	return SaveIntInSection(kParamNKey, GetParamN());	
}
////////////////////////////////////////////////////////////////////////////////////
void CConfigSPCCustomDll::SetParamN(int iValue)
{
	StartCfgAccess();
	mParamN=iValue;
	// Notify listeners that this param has changed, this way OnConfigChange(int iConfigID, int iConfigEvent) is called on listeners
	Broadcast(kCfgEventParamNChange);
	// we also can call Broadcast() that only notify the listeners that a param in this config has changed, this way OnConfigChange(int iConfigID) is called on listeners
	EndCfgAccess();
}
////////////////////////////////////////////////////////////////////////////////////
int CConfigSPCCustomDll::GetParamN()
{
	return mParamN;
}
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////